/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.net.SyncTeamsMessage;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.FolderName;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TeamManager {
    public static final FolderName FOLDER_NAME = LevelResourceHooks.create((String)"ftbteams");
    private static final FolderName OLD_ID_FILE = LevelResourceHooks.create((String)"data/ftbchunks/info.json");
    public static TeamManager INSTANCE;
    public final MinecraftServer server;
    private UUID id;
    private boolean shouldSave;
    final Map<UUID, PlayerTeam> knownPlayers;
    final Map<UUID, Team> teamMap;
    Map<String, Team> nameMap;
    private CompoundNBT extraData;

    public TeamManager(MinecraftServer s) {
        this.server = s;
        this.knownPlayers = new LinkedHashMap<UUID, PlayerTeam>();
        this.teamMap = new LinkedHashMap<UUID, Team>();
        this.extraData = new CompoundNBT();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Map<UUID, PlayerTeam> getKnownPlayers() {
        return this.knownPlayers;
    }

    public Map<UUID, Team> getTeamMap() {
        return this.teamMap;
    }

    public Collection<Team> getTeams() {
        return this.getTeamMap().values();
    }

    public Map<String, Team> getTeamNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Team>();
            for (Team team : this.getTeams()) {
                this.nameMap.put(team.getStringID(), team);
            }
        }
        return this.nameMap;
    }

    @Nullable
    public Team getTeamByID(UUID uuid) {
        return uuid == Util.field_240973_b_ ? null : this.teamMap.get(uuid);
    }

    public PlayerTeam getInternalPlayerTeam(UUID uuid) {
        return this.knownPlayers.get(uuid);
    }

    @Nullable
    public Team getPlayerTeam(UUID uuid) {
        PlayerTeam t = this.knownPlayers.get(uuid);
        return t == null ? null : t.actualTeam;
    }

    public Team getPlayerTeam(ServerPlayerEntity player) {
        return Objects.requireNonNull(this.getPlayerTeam(player.func_110124_au()));
    }

    public boolean arePlayersInSameTeam(ServerPlayerEntity player1, ServerPlayerEntity player2) {
        return this.getPlayerTeam(player1).equals(this.getPlayerTeam(player2));
    }

    public UUID getPlayerTeamID(UUID id) {
        Team t = this.getPlayerTeam(id);
        return t == null ? id : t.getId();
    }

    public void load() {
        this.id = null;
        Path directory = this.server.func_240776_a_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        SNBTCompoundTag dataFileTag = SNBT.read((Path)directory.resolve("ftbteams.snbt"));
        if (dataFileTag != null) {
            if (dataFileTag.func_74764_b("id")) {
                this.id = UUID.fromString(dataFileTag.func_74779_i("id"));
            }
            this.extraData = dataFileTag.func_74775_l("extra");
            ((Consumer)TeamManagerEvent.LOADED.invoker()).accept(new TeamManagerEvent(this));
        } else {
            Path oldFile = this.server.func_240776_a_(OLD_ID_FILE);
            if (Files.exists(oldFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(oldFile);){
                    this.id = UUID.fromString(((JsonObject)new GsonBuilder().create().fromJson((Reader)reader, JsonObject.class)).get("id").getAsString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.save();
        }
        for (TeamType type : TeamType.MAP.values()) {
            Path dir = directory.resolve(type.func_176610_l());
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            try {
                for (Path file : Files.list(dir).filter(path -> path.getFileName().toString().endsWith(".snbt")).collect(Collectors.toList())) {
                    SNBTCompoundTag nbt = SNBT.read((Path)file);
                    if (nbt == null) continue;
                    Team team = type.factory.apply(this);
                    team.id = UUID.fromString(nbt.func_74779_i("id"));
                    this.teamMap.put(team.id, team);
                    team.deserializeNBT((CompoundNBT)nbt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Team team : this.teamMap.values()) {
            if (!(team instanceof PlayerTeam)) continue;
            this.knownPlayers.put(team.id, (PlayerTeam)team);
        }
        for (Team team : this.teamMap.values()) {
            if (!(team instanceof PartyTeam)) continue;
            for (UUID member : team.getMembers()) {
                PlayerTeam t = this.knownPlayers.get(member);
                if (t == null) continue;
                t.actualTeam = team;
            }
        }
        FTBTeams.LOGGER.info("Loaded FTB Teams - " + this.knownPlayers.size() + " known players");
    }

    public void save() {
        this.shouldSave = true;
        this.nameMap = null;
    }

    public void saveNow() {
        Path directory = this.server.func_240776_a_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.shouldSave) {
            ((Consumer)TeamManagerEvent.SAVED.invoker()).accept(new TeamManagerEvent(this));
            SNBT.write((Path)directory.resolve("ftbteams.snbt"), (CompoundNBT)this.serializeNBT());
            this.shouldSave = false;
        }
        for (TeamType type : TeamType.MAP.values()) {
            Path path = directory.resolve(type.func_176610_l());
            if (!Files.notExists(path, new LinkOption[0])) continue;
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Team team : this.getTeams()) {
            if (!team.shouldSave) continue;
            SNBT.write((Path)directory.resolve(team.getType().func_176610_l() + "/" + team.getId() + ".snbt"), (CompoundNBT)team.serializeNBT());
            team.shouldSave = false;
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.func_74778_a("id", this.getId().toString());
        nbt.func_218657_a("extra", (INBT)this.extraData);
        return nbt;
    }

    public ServerTeam createServerTeam(ServerPlayerEntity player, String name) {
        ServerTeam team = new ServerTeam(this);
        team.id = UUID.randomUUID();
        this.teamMap.put(team.id, team);
        team.setProperty(Team.DISPLAY_NAME, name.isEmpty() ? team.id.toString().substring(0, 8) : name);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.created(player);
        return team;
    }

    public PartyTeam createPartyTeam(ServerPlayerEntity player, String name) {
        PartyTeam team = new PartyTeam(this);
        team.id = UUID.randomUUID();
        team.owner = player.func_110124_au();
        this.teamMap.put(team.id, team);
        team.setProperty(Team.DISPLAY_NAME, name.isEmpty() ? player.func_146103_bH().getName() + "'s Party" : name);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.created(player);
        return team;
    }

    public void playerLoggedIn(@Nullable ServerPlayerEntity player, UUID id, String name) {
        PlayerTeam team = this.knownPlayers.get(id);
        boolean all = false;
        boolean created = false;
        if (team == null) {
            team = new PlayerTeam(this);
            team.id = id;
            team.playerName = name;
            this.teamMap.put(id, team);
            this.knownPlayers.put(id, team);
            team.setProperty(Team.DISPLAY_NAME, team.playerName);
            team.setProperty(Team.COLOR, FTBTUtils.randomColor());
            team.ranks.put(id, TeamRank.OWNER);
            created = true;
            team.save();
            this.save();
            all = true;
        }
        if (!team.playerName.equals(name)) {
            team.playerName = name;
            team.save();
            this.save();
            all = true;
        }
        if (all) {
            this.syncAll();
        } else if (player != null) {
            this.sync(player, team.actualTeam);
        }
        if (created) {
            if (player != null) {
                team.created(player);
            } else {
                team.save();
                this.save();
            }
            team.changedTeam(null, id, player, false);
        }
        team.online = true;
        team.updatePresence();
        if (player != null) {
            ((Consumer)TeamEvent.PLAYER_LOGGED_IN.invoker()).accept(new PlayerLoggedInAfterTeamEvent(team.actualTeam, player));
        }
    }

    public void playerLoggedOut(ServerPlayerEntity player) {
        PlayerTeam team = this.knownPlayers.get(player.func_110124_au());
        if (team != null) {
            team.online = false;
            team.updatePresence();
        }
    }

    public ClientTeamManager createClientTeamManager() {
        ClientTeamManager clientManager = new ClientTeamManager(this.getId());
        for (Team team : this.getTeams()) {
            ClientTeam t = new ClientTeam(clientManager, team);
            clientManager.teamMap.put(t.getId(), t);
            if (!(team instanceof PlayerTeam)) continue;
            clientManager.knownPlayers.put(team.getId(), new KnownClientPlayer((PlayerTeam)team));
        }
        return clientManager;
    }

    public void sync(ServerPlayerEntity player, Team self) {
        new SyncTeamsMessage(this.createClientTeamManager(), self).sendTo(player);
        this.server.func_184103_al().func_187243_f(player);
    }

    public void sync(ServerPlayerEntity player) {
        this.sync(player, this.getPlayerTeam(player));
    }

    public void syncAll() {
        this.save();
        ClientTeamManager clientManager = this.createClientTeamManager();
        for (ServerPlayerEntity player : this.server.func_184103_al().func_181057_v()) {
            new SyncTeamsMessage(clientManager, this.getPlayerTeam(player)).sendTo(player);
            this.server.func_184103_al().func_187243_f(player);
        }
    }

    public Pair<Integer, PartyTeam> createParty(ServerPlayerEntity player, String name) throws CommandSyntaxException {
        UUID id = player.func_110124_au();
        Team oldTeam = this.getPlayerTeam(player);
        if (!oldTeam.getType().isPlayer()) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PartyTeam team = this.createPartyTeam(player, name);
        ((PlayerTeam)oldTeam).actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        team.sendMessage(Util.field_240973_b_, (ITextComponent)new StringTextComponent("").func_230529_a_(player.func_200200_C_()).func_240702_b_(" joined your party!").func_240699_a_(TextFormatting.YELLOW));
        team.save();
        oldTeam.ranks.remove(id);
        oldTeam.save();
        ((PlayerTeam)oldTeam).updatePresence();
        this.syncAll();
        team.changedTeam(oldTeam, id, player, false);
        return Pair.of((Object)1, (Object)team);
    }

    public Pair<Integer, ServerTeam> createServer(CommandSource source, String name) throws CommandSyntaxException {
        ServerTeam team = this.createServerTeam(source.func_197035_h(), name);
        source.func_197030_a((ITextComponent)new StringTextComponent("Created new server team ").func_230529_a_(team.getName()), true);
        this.syncAll();
        return Pair.of((Object)1, (Object)team);
    }

    public ITextComponent getName(@Nullable UUID id) {
        if (id == null || id.equals(Util.field_240973_b_)) {
            return new StringTextComponent("System").func_240699_a_(TextFormatting.LIGHT_PURPLE);
        }
        PlayerTeam team = this.knownPlayers.get(id);
        return new StringTextComponent(team == null ? "Unknown" : team.playerName).func_240699_a_(TextFormatting.YELLOW);
    }

    public CompoundNBT getExtraData() {
        return this.extraData;
    }
}

